# This file was automatically generated by SWIG (https://www.swig.org).
# Version 4.3.1
#
# Do not make changes to this file unless you know what you are doing - modify
# the SWIG interface file instead.

from sys import version_info as _swig_python_version_info
# Import the low-level C/C++ module
if __package__ or "." in __name__:
    from . import _selinux
else:
    import _selinux

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)


def _swig_setattr_nondynamic_instance_variable(set):
    def set_instance_attr(self, name, value):
        if name == "this":
            set(self, name, value)
        elif name == "thisown":
            self.this.own(value)
        elif hasattr(self, name) and isinstance(getattr(type(self), name), property):
            set(self, name, value)
        else:
            raise AttributeError("You cannot add instance attributes to %s" % self)
    return set_instance_attr


def _swig_setattr_nondynamic_class_variable(set):
    def set_class_attr(cls, name, value):
        if hasattr(cls, name) and not isinstance(getattr(cls, name), property):
            set(cls, name, value)
        else:
            raise AttributeError("You cannot add class attributes to %s" % cls)
    return set_class_attr


def _swig_add_metaclass(metaclass):
    """Class decorator for adding a metaclass to a SWIG wrapped class - a slimmed down version of six.add_metaclass"""
    def wrapper(cls):
        return metaclass(cls.__name__, cls.__bases__, cls.__dict__.copy())
    return wrapper


class _SwigNonDynamicMeta(type):
    """Meta class to enforce nondynamic attributes (no new attributes) for a class"""
    __setattr__ = _swig_setattr_nondynamic_class_variable(type.__setattr__)




import shutil
import os

DISABLED = -1
PERMISSIVE = 0
ENFORCING = 1

def restorecon(path, recursive=False, verbose=False, force=False, nthreads=1):
    """ Restore SELinux context on a given path

    Arguments:
    path -- The pathname for the file or directory to be relabeled.

    Keyword arguments:
    recursive -- Change files and directories file labels recursively (default False)
    verbose -- Show changes in file labels (default False)
    force -- Force reset of context to match file_context for customizable files,
    and the default file context, changing the user, role, range portion  as well
    as the type (default False)
    nthreads -- The number of threads to use during relabeling, or 0 to use as many
    threads as there are online CPU cores (default 1)
    """

    restorecon_flags = SELINUX_RESTORECON_IGNORE_DIGEST | SELINUX_RESTORECON_REALPATH
    if recursive:
        restorecon_flags |= SELINUX_RESTORECON_RECURSE
    if verbose:
        restorecon_flags |= SELINUX_RESTORECON_VERBOSE
    if force:
        restorecon_flags |= SELINUX_RESTORECON_SET_SPECFILE_CTX
    selinux_restorecon_parallel(os.path.expanduser(path), restorecon_flags, nthreads)

def chcon(path, context, recursive=False):
    """ Set the SELinux context on a given path """
    lsetfilecon(path, context)
    if recursive:
        for root, dirs, files in os.walk(path):
            for name in files + dirs:
                lsetfilecon(os.path.join(root, name), context)

def copytree(src, dest):
    """ An SELinux-friendly shutil.copytree method """
    shutil.copytree(src, dest)
    restorecon(dest, recursive=True)

def install(src, dest):
    """ An SELinux-friendly shutil.move method """
    shutil.move(src, dest)
    restorecon(dest, recursive=True)

class security_id(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    ctx = property(_selinux.security_id_ctx_get, _selinux.security_id_ctx_set)
    id = property(_selinux.security_id_id_get, _selinux.security_id_id_set)

    def __init__(self):
        _selinux.security_id_swiginit(self, _selinux.new_security_id())
    __swig_destroy__ = _selinux.delete_security_id

# Register security_id in _selinux:
_selinux.security_id_swigregister(security_id)

def avc_sid_to_context(sid):
    return _selinux.avc_sid_to_context(sid)

def avc_sid_to_context_raw(sid):
    return _selinux.avc_sid_to_context_raw(sid)

def avc_context_to_sid(ctx):
    return _selinux.avc_context_to_sid(ctx)

def avc_context_to_sid_raw(ctx):
    return _selinux.avc_context_to_sid_raw(ctx)

def sidget(sid):
    return _selinux.sidget(sid)

def sidput(sid):
    return _selinux.sidput(sid)

def avc_get_initial_sid(name):
    return _selinux.avc_get_initial_sid(name)
class avc_entry_ref(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    ae = property(_selinux.avc_entry_ref_ae_get, _selinux.avc_entry_ref_ae_set)

    def __init__(self):
        _selinux.avc_entry_ref_swiginit(self, _selinux.new_avc_entry_ref())
    __swig_destroy__ = _selinux.delete_avc_entry_ref

# Register avc_entry_ref in _selinux:
_selinux.avc_entry_ref_swigregister(avc_entry_ref)
class avc_memory_callback(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    func_malloc = property(_selinux.avc_memory_callback_func_malloc_get, _selinux.avc_memory_callback_func_malloc_set)
    func_free = property(_selinux.avc_memory_callback_func_free_get, _selinux.avc_memory_callback_func_free_set)

    def __init__(self):
        _selinux.avc_memory_callback_swiginit(self, _selinux.new_avc_memory_callback())
    __swig_destroy__ = _selinux.delete_avc_memory_callback

# Register avc_memory_callback in _selinux:
_selinux.avc_memory_callback_swigregister(avc_memory_callback)
class avc_log_callback(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    func_log = property(_selinux.avc_log_callback_func_log_get, _selinux.avc_log_callback_func_log_set)
    func_audit = property(_selinux.avc_log_callback_func_audit_get, _selinux.avc_log_callback_func_audit_set)

    def __init__(self):
        _selinux.avc_log_callback_swiginit(self, _selinux.new_avc_log_callback())
    __swig_destroy__ = _selinux.delete_avc_log_callback

# Register avc_log_callback in _selinux:
_selinux.avc_log_callback_swigregister(avc_log_callback)
class avc_thread_callback(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    func_create_thread = property(_selinux.avc_thread_callback_func_create_thread_get, _selinux.avc_thread_callback_func_create_thread_set)
    func_stop_thread = property(_selinux.avc_thread_callback_func_stop_thread_get, _selinux.avc_thread_callback_func_stop_thread_set)

    def __init__(self):
        _selinux.avc_thread_callback_swiginit(self, _selinux.new_avc_thread_callback())
    __swig_destroy__ = _selinux.delete_avc_thread_callback

# Register avc_thread_callback in _selinux:
_selinux.avc_thread_callback_swigregister(avc_thread_callback)
class avc_lock_callback(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    func_alloc_lock = property(_selinux.avc_lock_callback_func_alloc_lock_get, _selinux.avc_lock_callback_func_alloc_lock_set)
    func_get_lock = property(_selinux.avc_lock_callback_func_get_lock_get, _selinux.avc_lock_callback_func_get_lock_set)
    func_release_lock = property(_selinux.avc_lock_callback_func_release_lock_get, _selinux.avc_lock_callback_func_release_lock_set)
    func_free_lock = property(_selinux.avc_lock_callback_func_free_lock_get, _selinux.avc_lock_callback_func_free_lock_set)

    def __init__(self):
        _selinux.avc_lock_callback_swiginit(self, _selinux.new_avc_lock_callback())
    __swig_destroy__ = _selinux.delete_avc_lock_callback

# Register avc_lock_callback in _selinux:
_selinux.avc_lock_callback_swigregister(avc_lock_callback)
AVC_OPT_UNUSED = _selinux.AVC_OPT_UNUSED
AVC_OPT_SETENFORCE = _selinux.AVC_OPT_SETENFORCE

def avc_init(msgprefix, mem_callbacks, log_callbacks, thread_callbacks, lock_callbacks):
    return _selinux.avc_init(msgprefix, mem_callbacks, log_callbacks, thread_callbacks, lock_callbacks)

def avc_open(opts, nopts):
    return _selinux.avc_open(opts, nopts)

def avc_cleanup():
    return _selinux.avc_cleanup()

def avc_reset():
    return _selinux.avc_reset()

def avc_destroy():
    return _selinux.avc_destroy()

def avc_has_perm_noaudit(ssid, tsid, tclass, requested, aeref, avd):
    return _selinux.avc_has_perm_noaudit(ssid, tsid, tclass, requested, aeref, avd)

def avc_has_perm(ssid, tsid, tclass, requested, aeref):
    return _selinux.avc_has_perm(ssid, tsid, tclass, requested, aeref)

def avc_audit(ssid, tsid, tclass, requested, avd, result):
    return _selinux.avc_audit(ssid, tsid, tclass, requested, avd, result)

def avc_compute_create(ssid, tsid, tclass):
    return _selinux.avc_compute_create(ssid, tsid, tclass)

def avc_compute_member(ssid, tsid, tclass):
    return _selinux.avc_compute_member(ssid, tsid, tclass)
AVC_CALLBACK_GRANT = _selinux.AVC_CALLBACK_GRANT
AVC_CALLBACK_TRY_REVOKE = _selinux.AVC_CALLBACK_TRY_REVOKE
AVC_CALLBACK_REVOKE = _selinux.AVC_CALLBACK_REVOKE
AVC_CALLBACK_RESET = _selinux.AVC_CALLBACK_RESET
AVC_CALLBACK_AUDITALLOW_ENABLE = _selinux.AVC_CALLBACK_AUDITALLOW_ENABLE
AVC_CALLBACK_AUDITALLOW_DISABLE = _selinux.AVC_CALLBACK_AUDITALLOW_DISABLE
AVC_CALLBACK_AUDITDENY_ENABLE = _selinux.AVC_CALLBACK_AUDITDENY_ENABLE
AVC_CALLBACK_AUDITDENY_DISABLE = _selinux.AVC_CALLBACK_AUDITDENY_DISABLE
AVC_CACHE_STATS = _selinux.AVC_CACHE_STATS
class avc_cache_stats(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    entry_lookups = property(_selinux.avc_cache_stats_entry_lookups_get, _selinux.avc_cache_stats_entry_lookups_set)
    entry_hits = property(_selinux.avc_cache_stats_entry_hits_get, _selinux.avc_cache_stats_entry_hits_set)
    entry_misses = property(_selinux.avc_cache_stats_entry_misses_get, _selinux.avc_cache_stats_entry_misses_set)
    entry_discards = property(_selinux.avc_cache_stats_entry_discards_get, _selinux.avc_cache_stats_entry_discards_set)
    cav_lookups = property(_selinux.avc_cache_stats_cav_lookups_get, _selinux.avc_cache_stats_cav_lookups_set)
    cav_hits = property(_selinux.avc_cache_stats_cav_hits_get, _selinux.avc_cache_stats_cav_hits_set)
    cav_probes = property(_selinux.avc_cache_stats_cav_probes_get, _selinux.avc_cache_stats_cav_probes_set)
    cav_misses = property(_selinux.avc_cache_stats_cav_misses_get, _selinux.avc_cache_stats_cav_misses_set)

    def __init__(self):
        _selinux.avc_cache_stats_swiginit(self, _selinux.new_avc_cache_stats())
    __swig_destroy__ = _selinux.delete_avc_cache_stats

# Register avc_cache_stats in _selinux:
_selinux.avc_cache_stats_swigregister(avc_cache_stats)

def avc_av_stats():
    return _selinux.avc_av_stats()

def avc_sid_stats():
    return _selinux.avc_sid_stats()

def avc_netlink_open(blocking):
    return _selinux.avc_netlink_open(blocking)

def avc_netlink_loop():
    return _selinux.avc_netlink_loop()

def avc_netlink_close():
    return _selinux.avc_netlink_close()

def selinux_status_open(fallback):
    return _selinux.selinux_status_open(fallback)

def selinux_status_close():
    return _selinux.selinux_status_close()

def selinux_status_updated():
    return _selinux.selinux_status_updated()

def selinux_status_getenforce():
    return _selinux.selinux_status_getenforce()

def selinux_status_policyload():
    return _selinux.selinux_status_policyload()

def selinux_status_deny_unknown():
    return _selinux.selinux_status_deny_unknown()
class context_s_t(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    ptr = property(_selinux.context_s_t_ptr_get, _selinux.context_s_t_ptr_set)

    def __init__(self):
        _selinux.context_s_t_swiginit(self, _selinux.new_context_s_t())
    __swig_destroy__ = _selinux.delete_context_s_t

# Register context_s_t in _selinux:
_selinux.context_s_t_swigregister(context_s_t)

def context_new(str):
    return _selinux.context_new(str)

def context_str(con):
    return _selinux.context_str(con)

def context_free(con):
    return _selinux.context_free(con)

def context_type_get(con):
    return _selinux.context_type_get(con)

def context_range_get(con):
    return _selinux.context_range_get(con)

def context_role_get(con):
    return _selinux.context_role_get(con)

def context_user_get(con):
    return _selinux.context_user_get(con)

def context_type_set(con, type):
    return _selinux.context_type_set(con, type)

def context_range_set(con, range):
    return _selinux.context_range_set(con, range)

def context_role_set(con, role):
    return _selinux.context_role_set(con, role)

def context_user_set(con, user):
    return _selinux.context_user_set(con, user)
SELINUX_DEFAULTUSER = _selinux.SELINUX_DEFAULTUSER

def get_ordered_context_list(user, fromcon):
    return _selinux.get_ordered_context_list(user, fromcon)

def get_ordered_context_list_with_level(user, level, fromcon):
    return _selinux.get_ordered_context_list_with_level(user, level, fromcon)

def get_default_context(user, fromcon):
    return _selinux.get_default_context(user, fromcon)

def get_default_context_with_level(user, level, fromcon):
    return _selinux.get_default_context_with_level(user, level, fromcon)

def get_default_context_with_role(user, role, fromcon):
    return _selinux.get_default_context_with_role(user, role, fromcon)

def get_default_context_with_rolelevel(user, role, level, fromcon):
    return _selinux.get_default_context_with_rolelevel(user, role, level, fromcon)

def query_user_context():
    return _selinux.query_user_context()

def manual_user_enter_context(user):
    return _selinux.manual_user_enter_context(user)

def selinux_default_type_path():
    return _selinux.selinux_default_type_path()

def get_default_type(role):
    return _selinux.get_default_type(role)
SELABEL_CTX_FILE = _selinux.SELABEL_CTX_FILE
SELABEL_CTX_MEDIA = _selinux.SELABEL_CTX_MEDIA
SELABEL_CTX_X = _selinux.SELABEL_CTX_X
SELABEL_CTX_DB = _selinux.SELABEL_CTX_DB
SELABEL_CTX_ANDROID_PROP = _selinux.SELABEL_CTX_ANDROID_PROP
SELABEL_CTX_ANDROID_SERVICE = _selinux.SELABEL_CTX_ANDROID_SERVICE
SELABEL_OPT_UNUSED = _selinux.SELABEL_OPT_UNUSED
SELABEL_OPT_VALIDATE = _selinux.SELABEL_OPT_VALIDATE
SELABEL_OPT_BASEONLY = _selinux.SELABEL_OPT_BASEONLY
SELABEL_OPT_PATH = _selinux.SELABEL_OPT_PATH
SELABEL_OPT_SUBSET = _selinux.SELABEL_OPT_SUBSET
SELABEL_OPT_DIGEST = _selinux.SELABEL_OPT_DIGEST
SELABEL_NOPT = _selinux.SELABEL_NOPT

def selabel_open(backend, opts, nopts):
    return _selinux.selabel_open(backend, opts, nopts)

def selabel_close(handle):
    return _selinux.selabel_close(handle)

def selabel_lookup(handle, key, type):
    return _selinux.selabel_lookup(handle, key, type)

def selabel_lookup_raw(handle, key, type):
    return _selinux.selabel_lookup_raw(handle, key, type)

def selabel_partial_match(handle, key):
    return _selinux.selabel_partial_match(handle, key)

def selabel_get_digests_all_partial_matches(rec, key, calculated_digest, xattr_digest):
    return _selinux.selabel_get_digests_all_partial_matches(rec, key, calculated_digest, xattr_digest)

def selabel_hash_all_partial_matches(rec, key, digest):
    return _selinux.selabel_hash_all_partial_matches(rec, key, digest)

def selabel_lookup_best_match(rec, key, type):
    return _selinux.selabel_lookup_best_match(rec, key, type)

def selabel_lookup_best_match_raw(rec, key, type):
    return _selinux.selabel_lookup_best_match_raw(rec, key, type)

def selabel_digest(rec, digest):
    return _selinux.selabel_digest(rec, digest)
SELABEL_SUBSET = _selinux.SELABEL_SUBSET
SELABEL_EQUAL = _selinux.SELABEL_EQUAL
SELABEL_SUPERSET = _selinux.SELABEL_SUPERSET
SELABEL_INCOMPARABLE = _selinux.SELABEL_INCOMPARABLE

def selabel_cmp(h1, h2):
    return _selinux.selabel_cmp(h1, h2)

def selabel_stats(handle):
    return _selinux.selabel_stats(handle)
SELABEL_X_PROP = _selinux.SELABEL_X_PROP
SELABEL_X_EXT = _selinux.SELABEL_X_EXT
SELABEL_X_CLIENT = _selinux.SELABEL_X_CLIENT
SELABEL_X_EVENT = _selinux.SELABEL_X_EVENT
SELABEL_X_SELN = _selinux.SELABEL_X_SELN
SELABEL_X_POLYPROP = _selinux.SELABEL_X_POLYPROP
SELABEL_X_POLYSELN = _selinux.SELABEL_X_POLYSELN
SELABEL_DB_DATABASE = _selinux.SELABEL_DB_DATABASE
SELABEL_DB_SCHEMA = _selinux.SELABEL_DB_SCHEMA
SELABEL_DB_TABLE = _selinux.SELABEL_DB_TABLE
SELABEL_DB_COLUMN = _selinux.SELABEL_DB_COLUMN
SELABEL_DB_SEQUENCE = _selinux.SELABEL_DB_SEQUENCE
SELABEL_DB_VIEW = _selinux.SELABEL_DB_VIEW
SELABEL_DB_PROCEDURE = _selinux.SELABEL_DB_PROCEDURE
SELABEL_DB_BLOB = _selinux.SELABEL_DB_BLOB
SELABEL_DB_TUPLE = _selinux.SELABEL_DB_TUPLE
SELABEL_DB_LANGUAGE = _selinux.SELABEL_DB_LANGUAGE
SELABEL_DB_EXCEPTION = _selinux.SELABEL_DB_EXCEPTION
SELABEL_DB_DATATYPE = _selinux.SELABEL_DB_DATATYPE

def selinux_restorecon(pathname, restorecon_flags):
    return _selinux.selinux_restorecon(pathname, restorecon_flags)

def selinux_restorecon_parallel(pathname, restorecon_flags, nthreads):
    return _selinux.selinux_restorecon_parallel(pathname, restorecon_flags, nthreads)
SELINUX_RESTORECON_IGNORE_DIGEST = _selinux.SELINUX_RESTORECON_IGNORE_DIGEST
SELINUX_RESTORECON_NOCHANGE = _selinux.SELINUX_RESTORECON_NOCHANGE
SELINUX_RESTORECON_SET_SPECFILE_CTX = _selinux.SELINUX_RESTORECON_SET_SPECFILE_CTX
SELINUX_RESTORECON_RECURSE = _selinux.SELINUX_RESTORECON_RECURSE
SELINUX_RESTORECON_VERBOSE = _selinux.SELINUX_RESTORECON_VERBOSE
SELINUX_RESTORECON_PROGRESS = _selinux.SELINUX_RESTORECON_PROGRESS
SELINUX_RESTORECON_REALPATH = _selinux.SELINUX_RESTORECON_REALPATH
SELINUX_RESTORECON_XDEV = _selinux.SELINUX_RESTORECON_XDEV
SELINUX_RESTORECON_ADD_ASSOC = _selinux.SELINUX_RESTORECON_ADD_ASSOC
SELINUX_RESTORECON_ABORT_ON_ERROR = _selinux.SELINUX_RESTORECON_ABORT_ON_ERROR
SELINUX_RESTORECON_SYSLOG_CHANGES = _selinux.SELINUX_RESTORECON_SYSLOG_CHANGES
SELINUX_RESTORECON_LOG_MATCHES = _selinux.SELINUX_RESTORECON_LOG_MATCHES
SELINUX_RESTORECON_IGNORE_NOENTRY = _selinux.SELINUX_RESTORECON_IGNORE_NOENTRY
SELINUX_RESTORECON_IGNORE_MOUNTS = _selinux.SELINUX_RESTORECON_IGNORE_MOUNTS
SELINUX_RESTORECON_MASS_RELABEL = _selinux.SELINUX_RESTORECON_MASS_RELABEL
SELINUX_RESTORECON_SKIP_DIGEST = _selinux.SELINUX_RESTORECON_SKIP_DIGEST
SELINUX_RESTORECON_CONFLICT_ERROR = _selinux.SELINUX_RESTORECON_CONFLICT_ERROR
SELINUX_RESTORECON_COUNT_ERRORS = _selinux.SELINUX_RESTORECON_COUNT_ERRORS

def selinux_restorecon_set_sehandle(hndl):
    return _selinux.selinux_restorecon_set_sehandle(hndl)

def selinux_restorecon_default_handle():
    return _selinux.selinux_restorecon_default_handle()

def selinux_restorecon_set_exclude_list():
    return _selinux.selinux_restorecon_set_exclude_list()

def selinux_restorecon_set_alt_rootpath(alt_rootpath):
    return _selinux.selinux_restorecon_set_alt_rootpath(alt_rootpath)
MATCH = _selinux.MATCH
NOMATCH = _selinux.NOMATCH
DELETED_MATCH = _selinux.DELETED_MATCH
DELETED_NOMATCH = _selinux.DELETED_NOMATCH
ERROR = _selinux.ERROR
class dir_xattr(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    directory = property(_selinux.dir_xattr_directory_get, _selinux.dir_xattr_directory_set)
    digest = property(_selinux.dir_xattr_digest_get, _selinux.dir_xattr_digest_set)
    result = property(_selinux.dir_xattr_result_get, _selinux.dir_xattr_result_set)
    next = property(_selinux.dir_xattr_next_get, _selinux.dir_xattr_next_set)

    def __init__(self):
        _selinux.dir_xattr_swiginit(self, _selinux.new_dir_xattr())
    __swig_destroy__ = _selinux.delete_dir_xattr

# Register dir_xattr in _selinux:
_selinux.dir_xattr_swigregister(dir_xattr)

def selinux_restorecon_xattr(pathname, xattr_flags, xattr_list):
    return _selinux.selinux_restorecon_xattr(pathname, xattr_flags, xattr_list)
SELINUX_RESTORECON_XATTR_RECURSE = _selinux.SELINUX_RESTORECON_XATTR_RECURSE
SELINUX_RESTORECON_XATTR_DELETE_NONMATCH_DIGESTS = _selinux.SELINUX_RESTORECON_XATTR_DELETE_NONMATCH_DIGESTS
SELINUX_RESTORECON_XATTR_DELETE_ALL_DIGESTS = _selinux.SELINUX_RESTORECON_XATTR_DELETE_ALL_DIGESTS
SELINUX_RESTORECON_XATTR_IGNORE_MOUNTS = _selinux.SELINUX_RESTORECON_XATTR_IGNORE_MOUNTS

def selinux_restorecon_get_skipped_errors():
    return _selinux.selinux_restorecon_get_skipped_errors()

def is_selinux_enabled():
    return _selinux.is_selinux_enabled()

def is_selinux_mls_enabled():
    return _selinux.is_selinux_mls_enabled()

def getcon():
    return _selinux.getcon()

def getcon_raw():
    return _selinux.getcon_raw()

def setcon(con):
    return _selinux.setcon(con)

def setcon_raw(con):
    return _selinux.setcon_raw(con)

def getpidcon(pid):
    return _selinux.getpidcon(pid)

def getpidcon_raw(pid):
    return _selinux.getpidcon_raw(pid)

def getprevcon():
    return _selinux.getprevcon()

def getprevcon_raw():
    return _selinux.getprevcon_raw()

def getpidprevcon(pid):
    return _selinux.getpidprevcon(pid)

def getpidprevcon_raw(pid):
    return _selinux.getpidprevcon_raw(pid)

def getexeccon():
    return _selinux.getexeccon()

def getexeccon_raw():
    return _selinux.getexeccon_raw()

def setexeccon(con):
    return _selinux.setexeccon(con)

def setexeccon_raw(con):
    return _selinux.setexeccon_raw(con)

def getfscreatecon():
    return _selinux.getfscreatecon()

def getfscreatecon_raw():
    return _selinux.getfscreatecon_raw()

def setfscreatecon(context):
    return _selinux.setfscreatecon(context)

def setfscreatecon_raw(context):
    return _selinux.setfscreatecon_raw(context)

def getkeycreatecon():
    return _selinux.getkeycreatecon()

def getkeycreatecon_raw():
    return _selinux.getkeycreatecon_raw()

def setkeycreatecon(context):
    return _selinux.setkeycreatecon(context)

def setkeycreatecon_raw(context):
    return _selinux.setkeycreatecon_raw(context)

def getsockcreatecon():
    return _selinux.getsockcreatecon()

def getsockcreatecon_raw():
    return _selinux.getsockcreatecon_raw()

def setsockcreatecon(context):
    return _selinux.setsockcreatecon(context)

def setsockcreatecon_raw(context):
    return _selinux.setsockcreatecon_raw(context)

def getfilecon(path):
    return _selinux.getfilecon(path)

def getfilecon_raw(path):
    return _selinux.getfilecon_raw(path)

def lgetfilecon(path):
    return _selinux.lgetfilecon(path)

def lgetfilecon_raw(path):
    return _selinux.lgetfilecon_raw(path)

def fgetfilecon(fd):
    return _selinux.fgetfilecon(fd)

def fgetfilecon_raw(fd):
    return _selinux.fgetfilecon_raw(fd)

def setfilecon(path, con):
    return _selinux.setfilecon(path, con)

def setfilecon_raw(path, con):
    return _selinux.setfilecon_raw(path, con)

def lsetfilecon(path, con):
    return _selinux.lsetfilecon(path, con)

def lsetfilecon_raw(path, con):
    return _selinux.lsetfilecon_raw(path, con)

def fsetfilecon(fd, con):
    return _selinux.fsetfilecon(fd, con)

def fsetfilecon_raw(fd, con):
    return _selinux.fsetfilecon_raw(fd, con)

def getpeercon(fd):
    return _selinux.getpeercon(fd)

def getpeercon_raw(fd):
    return _selinux.getpeercon_raw(fd)
class av_decision(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    allowed = property(_selinux.av_decision_allowed_get, _selinux.av_decision_allowed_set)
    decided = property(_selinux.av_decision_decided_get, _selinux.av_decision_decided_set)
    auditallow = property(_selinux.av_decision_auditallow_get, _selinux.av_decision_auditallow_set)
    auditdeny = property(_selinux.av_decision_auditdeny_get, _selinux.av_decision_auditdeny_set)
    seqno = property(_selinux.av_decision_seqno_get, _selinux.av_decision_seqno_set)
    flags = property(_selinux.av_decision_flags_get, _selinux.av_decision_flags_set)

    def __init__(self):
        _selinux.av_decision_swiginit(self, _selinux.new_av_decision())
    __swig_destroy__ = _selinux.delete_av_decision

# Register av_decision in _selinux:
_selinux.av_decision_swigregister(av_decision)
SELINUX_AVD_FLAGS_PERMISSIVE = _selinux.SELINUX_AVD_FLAGS_PERMISSIVE
class selinux_opt(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    type = property(_selinux.selinux_opt_type_get, _selinux.selinux_opt_type_set)
    value = property(_selinux.selinux_opt_value_get, _selinux.selinux_opt_value_set)

    def __init__(self):
        _selinux.selinux_opt_swiginit(self, _selinux.new_selinux_opt())
    __swig_destroy__ = _selinux.delete_selinux_opt

# Register selinux_opt in _selinux:
_selinux.selinux_opt_swigregister(selinux_opt)
class selinux_callback(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    func_log = property(_selinux.selinux_callback_func_log_get, _selinux.selinux_callback_func_log_set)
    func_audit = property(_selinux.selinux_callback_func_audit_get, _selinux.selinux_callback_func_audit_set)
    func_validate = property(_selinux.selinux_callback_func_validate_get, _selinux.selinux_callback_func_validate_set)
    func_setenforce = property(_selinux.selinux_callback_func_setenforce_get, _selinux.selinux_callback_func_setenforce_set)
    func_policyload = property(_selinux.selinux_callback_func_policyload_get, _selinux.selinux_callback_func_policyload_set)

    def __init__(self):
        _selinux.selinux_callback_swiginit(self, _selinux.new_selinux_callback())
    __swig_destroy__ = _selinux.delete_selinux_callback

# Register selinux_callback in _selinux:
_selinux.selinux_callback_swigregister(selinux_callback)
SELINUX_CB_LOG = _selinux.SELINUX_CB_LOG
SELINUX_CB_AUDIT = _selinux.SELINUX_CB_AUDIT
SELINUX_CB_VALIDATE = _selinux.SELINUX_CB_VALIDATE
SELINUX_CB_SETENFORCE = _selinux.SELINUX_CB_SETENFORCE
SELINUX_CB_POLICYLOAD = _selinux.SELINUX_CB_POLICYLOAD

def selinux_get_callback(type):
    return _selinux.selinux_get_callback(type)

def selinux_set_callback(type, cb):
    return _selinux.selinux_set_callback(type, cb)
SELINUX_ERROR = _selinux.SELINUX_ERROR
SELINUX_WARNING = _selinux.SELINUX_WARNING
SELINUX_INFO = _selinux.SELINUX_INFO
SELINUX_AVC = _selinux.SELINUX_AVC
SELINUX_POLICYLOAD = _selinux.SELINUX_POLICYLOAD
SELINUX_SETENFORCE = _selinux.SELINUX_SETENFORCE
SELINUX_TRANS_DIR = _selinux.SELINUX_TRANS_DIR

def security_compute_av(scon, tcon, tclass, requested, avd):
    return _selinux.security_compute_av(scon, tcon, tclass, requested, avd)

def security_compute_av_raw(scon, tcon, tclass, requested, avd):
    return _selinux.security_compute_av_raw(scon, tcon, tclass, requested, avd)

def security_compute_av_flags(scon, tcon, tclass, requested, avd):
    return _selinux.security_compute_av_flags(scon, tcon, tclass, requested, avd)

def security_compute_av_flags_raw(scon, tcon, tclass, requested, avd):
    return _selinux.security_compute_av_flags_raw(scon, tcon, tclass, requested, avd)

def security_compute_create(scon, tcon, tclass):
    return _selinux.security_compute_create(scon, tcon, tclass)

def security_compute_create_raw(scon, tcon, tclass):
    return _selinux.security_compute_create_raw(scon, tcon, tclass)

def security_compute_create_name(scon, tcon, tclass, objname):
    return _selinux.security_compute_create_name(scon, tcon, tclass, objname)

def security_compute_create_name_raw(scon, tcon, tclass, objname):
    return _selinux.security_compute_create_name_raw(scon, tcon, tclass, objname)

def security_compute_relabel(scon, tcon, tclass):
    return _selinux.security_compute_relabel(scon, tcon, tclass)

def security_compute_relabel_raw(scon, tcon, tclass):
    return _selinux.security_compute_relabel_raw(scon, tcon, tclass)

def security_compute_member(scon, tcon, tclass):
    return _selinux.security_compute_member(scon, tcon, tclass)

def security_compute_member_raw(scon, tcon, tclass):
    return _selinux.security_compute_member_raw(scon, tcon, tclass)

def security_compute_user(scon, username):
    return _selinux.security_compute_user(scon, username)

def security_compute_user_raw(scon, username):
    return _selinux.security_compute_user_raw(scon, username)

def security_validatetrans(scon, tcon, tclass, newcon):
    return _selinux.security_validatetrans(scon, tcon, tclass, newcon)

def security_validatetrans_raw(scon, tcon, tclass, newcon):
    return _selinux.security_validatetrans_raw(scon, tcon, tclass, newcon)

def security_load_policy(len):
    return _selinux.security_load_policy(len)

def security_get_initial_context(name):
    return _selinux.security_get_initial_context(name)

def security_get_initial_context_raw(name):
    return _selinux.security_get_initial_context_raw(name)

def selinux_mkload_policy(preservebools):
    return _selinux.selinux_mkload_policy(preservebools)

def selinux_init_load_policy():
    return _selinux.selinux_init_load_policy()
class SELboolean(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    name = property(_selinux.SELboolean_name_get, _selinux.SELboolean_name_set)
    value = property(_selinux.SELboolean_value_get, _selinux.SELboolean_value_set)

    def __init__(self):
        _selinux.SELboolean_swiginit(self, _selinux.new_SELboolean())
    __swig_destroy__ = _selinux.delete_SELboolean

# Register SELboolean in _selinux:
_selinux.SELboolean_swigregister(SELboolean)

def security_set_boolean_list(boolcnt, boollist, permanent):
    return _selinux.security_set_boolean_list(boolcnt, boollist, permanent)

def security_load_booleans(path):
    return _selinux.security_load_booleans(path)

def security_check_context(con):
    return _selinux.security_check_context(con)

def security_check_context_raw(con):
    return _selinux.security_check_context_raw(con)

def security_canonicalize_context(con):
    return _selinux.security_canonicalize_context(con)

def security_canonicalize_context_raw(con):
    return _selinux.security_canonicalize_context_raw(con)

def security_getenforce():
    return _selinux.security_getenforce()

def security_setenforce(value):
    return _selinux.security_setenforce(value)

def security_reject_unknown():
    return _selinux.security_reject_unknown()

def security_deny_unknown():
    return _selinux.security_deny_unknown()

def security_get_checkreqprot():
    return _selinux.security_get_checkreqprot()

def security_disable():
    return _selinux.security_disable()

def security_policyvers():
    return _selinux.security_policyvers()

def security_get_boolean_names():
    return _selinux.security_get_boolean_names()

def security_get_boolean_pending(name):
    return _selinux.security_get_boolean_pending(name)

def security_get_boolean_active(name):
    return _selinux.security_get_boolean_active(name)

def security_set_boolean(name, value):
    return _selinux.security_set_boolean(name, value)

def security_commit_booleans():
    return _selinux.security_commit_booleans()
class security_class_mapping(object):
    thisown = property(lambda x: x.this.own(), lambda x, v: x.this.own(v), doc="The membership flag")
    __repr__ = _swig_repr
    name = property(_selinux.security_class_mapping_name_get, _selinux.security_class_mapping_name_set)
    perms = property(_selinux.security_class_mapping_perms_get, _selinux.security_class_mapping_perms_set)

    def __init__(self):
        _selinux.security_class_mapping_swiginit(self, _selinux.new_security_class_mapping())
    __swig_destroy__ = _selinux.delete_security_class_mapping

# Register security_class_mapping in _selinux:
_selinux.security_class_mapping_swigregister(security_class_mapping)

def selinux_set_mapping(map):
    return _selinux.selinux_set_mapping(map)

def mode_to_security_class(mode):
    return _selinux.mode_to_security_class(mode)

def string_to_security_class(name):
    return _selinux.string_to_security_class(name)

def security_class_to_string(cls):
    return _selinux.security_class_to_string(cls)

def security_av_perm_to_string(tclass, perm):
    return _selinux.security_av_perm_to_string(tclass, perm)

def string_to_av_perm(tclass, name):
    return _selinux.string_to_av_perm(tclass, name)

def security_av_string(tclass, av):
    return _selinux.security_av_string(tclass, av)

def print_access_vector(tclass, av):
    return _selinux.print_access_vector(tclass, av)

def selinux_flush_class_cache():
    return _selinux.selinux_flush_class_cache()
MATCHPATHCON_BASEONLY = _selinux.MATCHPATHCON_BASEONLY
MATCHPATHCON_NOTRANS = _selinux.MATCHPATHCON_NOTRANS
MATCHPATHCON_VALIDATE = _selinux.MATCHPATHCON_VALIDATE

def set_matchpathcon_flags(flags):
    return _selinux.set_matchpathcon_flags(flags)

def matchpathcon_init(path):
    return _selinux.matchpathcon_init(path)

def matchpathcon_init_prefix(path, prefix):
    return _selinux.matchpathcon_init_prefix(path, prefix)

def matchpathcon_fini():
    return _selinux.matchpathcon_fini()

def realpath_not_final(name, resolved_path):
    return _selinux.realpath_not_final(name, resolved_path)

def matchpathcon(path, mode):
    return _selinux.matchpathcon(path, mode)

def matchpathcon_index(path, mode):
    return _selinux.matchpathcon_index(path, mode)

def matchpathcon_filespec_add(ino, specind, file):
    return _selinux.matchpathcon_filespec_add(ino, specind, file)

def matchpathcon_filespec_destroy():
    return _selinux.matchpathcon_filespec_destroy()

def matchpathcon_filespec_eval():
    return _selinux.matchpathcon_filespec_eval()

def matchpathcon_checkmatches(str):
    return _selinux.matchpathcon_checkmatches(str)

def matchmediacon(media):
    return _selinux.matchmediacon(media)

def selinux_getenforcemode():
    return _selinux.selinux_getenforcemode()

def selinux_boolean_sub(boolean_name):
    return _selinux.selinux_boolean_sub(boolean_name)

def selinux_getpolicytype():
    return _selinux.selinux_getpolicytype()

def selinux_policy_root():
    return _selinux.selinux_policy_root()

def selinux_set_policy_root(rootpath):
    return _selinux.selinux_set_policy_root(rootpath)

def selinux_current_policy_path():
    return _selinux.selinux_current_policy_path()

def selinux_binary_policy_path():
    return _selinux.selinux_binary_policy_path()

def selinux_failsafe_context_path():
    return _selinux.selinux_failsafe_context_path()

def selinux_removable_context_path():
    return _selinux.selinux_removable_context_path()

def selinux_default_context_path():
    return _selinux.selinux_default_context_path()

def selinux_user_contexts_path():
    return _selinux.selinux_user_contexts_path()

def selinux_file_context_path():
    return _selinux.selinux_file_context_path()

def selinux_file_context_homedir_path():
    return _selinux.selinux_file_context_homedir_path()

def selinux_file_context_local_path():
    return _selinux.selinux_file_context_local_path()

def selinux_file_context_subs_path():
    return _selinux.selinux_file_context_subs_path()

def selinux_file_context_subs_dist_path():
    return _selinux.selinux_file_context_subs_dist_path()

def selinux_homedir_context_path():
    return _selinux.selinux_homedir_context_path()

def selinux_media_context_path():
    return _selinux.selinux_media_context_path()

def selinux_virtual_domain_context_path():
    return _selinux.selinux_virtual_domain_context_path()

def selinux_virtual_image_context_path():
    return _selinux.selinux_virtual_image_context_path()

def selinux_lxc_contexts_path():
    return _selinux.selinux_lxc_contexts_path()

def selinux_x_context_path():
    return _selinux.selinux_x_context_path()

def selinux_sepgsql_context_path():
    return _selinux.selinux_sepgsql_context_path()

def selinux_openrc_contexts_path():
    return _selinux.selinux_openrc_contexts_path()

def selinux_openssh_contexts_path():
    return _selinux.selinux_openssh_contexts_path()

def selinux_snapperd_contexts_path():
    return _selinux.selinux_snapperd_contexts_path()

def selinux_systemd_contexts_path():
    return _selinux.selinux_systemd_contexts_path()

def selinux_contexts_path():
    return _selinux.selinux_contexts_path()

def selinux_securetty_types_path():
    return _selinux.selinux_securetty_types_path()

def selinux_booleans_subs_path():
    return _selinux.selinux_booleans_subs_path()

def selinux_booleans_path():
    return _selinux.selinux_booleans_path()

def selinux_customizable_types_path():
    return _selinux.selinux_customizable_types_path()

def selinux_users_path():
    return _selinux.selinux_users_path()

def selinux_usersconf_path():
    return _selinux.selinux_usersconf_path()

def selinux_translations_path():
    return _selinux.selinux_translations_path()

def selinux_colors_path():
    return _selinux.selinux_colors_path()

def selinux_netfilter_context_path():
    return _selinux.selinux_netfilter_context_path()

def selinux_path():
    return _selinux.selinux_path()

def selinux_check_access(scon, tcon, tclass, perm):
    return _selinux.selinux_check_access(scon, tcon, tclass, perm)

def selinux_check_passwd_access(requested):
    return _selinux.selinux_check_passwd_access(requested)

def checkPasswdAccess(requested):
    return _selinux.checkPasswdAccess(requested)

def selinux_check_securetty_context(tty_context):
    return _selinux.selinux_check_securetty_context(tty_context)

def set_selinuxmnt(mnt):
    return _selinux.set_selinuxmnt(mnt)

def selinuxfs_exists():
    return _selinux.selinuxfs_exists()

def fini_selinuxmnt():
    return _selinux.fini_selinuxmnt()

def setexecfilecon(filename, fallback_type):
    return _selinux.setexecfilecon(filename, fallback_type)

def is_context_customizable(scontext):
    return _selinux.is_context_customizable(scontext)

def selinux_trans_to_raw_context(trans):
    return _selinux.selinux_trans_to_raw_context(trans)

def selinux_raw_to_trans_context(raw):
    return _selinux.selinux_raw_to_trans_context(raw)

def selinux_raw_context_to_color(raw):
    return _selinux.selinux_raw_context_to_color(raw)

def getseuserbyname(linuxuser):
    return _selinux.getseuserbyname(linuxuser)

def getseuser(username, service):
    return _selinux.getseuser(username, service)

def selinux_file_context_cmp(a, b):
    return _selinux.selinux_file_context_cmp(a, b)

def selinux_file_context_verify(path, mode):
    return _selinux.selinux_file_context_verify(path, mode)

def selinux_lsetfilecon_default(path):
    return _selinux.selinux_lsetfilecon_default(path)

def selinux_reset_config():
    return _selinux.selinux_reset_config()

